package com.hero.objects.perks;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.PerkDialog;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Perk extends GenericObject {

	protected String xmlID = "GENERIC_PERK";

	public Perk(Element template) {
		super(template);
	}

	public Perk(Element template, String xmlID) {
		super(template, xmlID);
		this.xmlID = xmlID;
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias();

		if ((getName() != null) && (getName().trim().length() > 0)) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			if (getAlias().trim().length() > 0) {
				ret += ":  ";
			}
			ret += getInput();
		}
		if ((getSelectedOption() != null) && showOption) {
			if ((getAlias().trim().length() > 0)
					|| ((getInput() != null) && (getInput().trim().length() > 0))) {
				ret += ":  ";
			}
			ret += getSelectedOption().getAlias();

			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += "; " + adderString;
			}
		} else {
			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += " (" + adderString + ")";
			}
		}
		ret += getModifierString();
		if ((getRoll() != null) && (getRoll().trim().length() > 0)) {
			ret += " " + getRoll();
		}

		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}

		return ret;
	}

	@Override
	public GenericDialog getDialog(boolean isNew, boolean isPower) {
		PerkDialog dialog = new PerkDialog(this, isNew, isPower);
		return dialog;
	}

	public String getRoll() {
		return "";
	}

	@Override
	public Element getSaveXML() {
		Element root = getGeneralSaveXML();
		root.setName("PERK");
		return root;
	}

	@Override
	protected void init(Element element) {
		duration = "CONSTANT";

		super.init(element);
		target = "SELFONLY";
		if (!types.contains("SPECIAL")) {
			types.add("SPECIAL");
		}
		String check = XMLUtility.getValue(element, "TARGET");
		if ((check != null) && (check.trim().length() > 0)) {
			target = check;
		}
	}

	@Override
	public void restoreFromSave(Element root) {
		super.restoreFromSave(root);
		String check = XMLUtility.getValue(root, "BASECOST");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				baseCost = Double.parseDouble(check);
			} catch (Exception exp) {
			}
		}
	}
}